/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.StringUtil;
import com.aptana.debug.core.DebugCorePlugin;
import com.aptana.debug.core.ILogLevelFilter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IProcess;

public class LogLevelFilterManager {
    private static final String EXTENSION_POINT_ID = "logLevelFilters";
    private static final String ELEMENT_TYPE = "filter";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CLASS = "class";
    private Map<String, IConfigurationElement> filters;

    protected LogLevelFilterManager() {
        this.loadFilters();
    }

    public ILogLevelFilter getFilter(String filterID, IProcess process) {
        IConfigurationElement element = this.filters.get(filterID);
        if (element == null) {
            return null;
        }
        ILogLevelFilter filter = null;
        try {
            Object clazz = element.createExecutableExtension(ATTR_CLASS);
            if (clazz instanceof ILogLevelFilter) {
                filter = (ILogLevelFilter)clazz;
                filter.setInitializationData(element, "process", process);
                if (filter instanceof IDebugEventSetListener) {
                    DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)filter);
                }
            } else {
                IdeLog.logError((Plugin)DebugCorePlugin.getDefault(), (String)MessageFormat.format("The class {0} does not implement ILogLevelFilter", element.getAttribute(ATTR_CLASS)));
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)DebugCorePlugin.getDefault(), (Throwable)e);
        }
        return filter;
    }

    private void loadFilters() {
        this.filters = new HashMap<String, IConfigurationElement>();
        EclipseUtil.processConfigurationElements((String)"com.aptana.debug.core", (String)EXTENSION_POINT_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                String elementName = element.getName();
                if (LogLevelFilterManager.ELEMENT_TYPE.equals(elementName)) {
                    String id = element.getAttribute(LogLevelFilterManager.ATTR_ID);
                    if (StringUtil.isEmpty((String)id)) {
                        return;
                    }
                    String className = element.getAttribute(LogLevelFilterManager.ATTR_CLASS);
                    if (StringUtil.isEmpty((String)className)) {
                        IdeLog.logError((Plugin)DebugCorePlugin.getDefault(), (String)"Missing an ILogLevelFilter class");
                        return;
                    }
                    LogLevelFilterManager.this.filters.put(id, element);
                }
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{LogLevelFilterManager.ELEMENT_TYPE});
            }
        });
    }
}

